<?php
/* --------------------------------------------------------------
  TrackingCodesContentView.inc.php 2020-04-09
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2017 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------
 */

use Gambio\Admin\ParcelService\Interfaces\ParcelServiceService;
use Gambio\Admin\ParcelService\SqlCriteria\ParcelServiceFilters;
use Gambio\Admin\ParcelService\SqlCriteria\ParcelServiceSorting;
use Gambio\Admin\ParcelService\SqlCriteria\ParcelServiceSortings;
use Gambio\Admin\ParcelService\SqlCriteria\ParcelServiceSqlCriteria;
use Gambio\Admin\ParcelService\SqlCriteria\ParcelServiceSqlPagination;
use Gambio\Admin\TrackingCode\Interfaces\TrackingCodeService;
use Gambio\Admin\TrackingCode\SqlCriteria\TrackingCodeFilter;
use Gambio\Admin\TrackingCode\SqlCriteria\TrackingCodeFilters;
use Gambio\Admin\TrackingCode\SqlCriteria\TrackingCodeSorting;
use Gambio\Admin\TrackingCode\SqlCriteria\TrackingCodeSortings;
use Gambio\Admin\TrackingCode\SqlCriteria\TrackingCodeSqlCriteria;
use Gambio\Admin\TrackingCode\SqlCriteria\TrackingCodeSqlPagination;

/**
 * Class TrackingCodesContentView
 */
class TrackingCodesContentView extends ContentView
{
    protected $orderId;
    
    protected $pageToken;
    
    /**
     * @var TrackingCodeService
     */
    protected $trackingCodeService;
    
    /**
     * @var ParcelServiceService
     */
    protected $parcelServiceService;
    
    
    public function __construct()
    {
        parent::__construct();
        $this->set_template_dir(DIR_FS_CATALOG . 'admin/html/content/tracking/');
        $this->set_content_template('tracking_codes.html');
        
        $container = LegacyDependencyContainer::getInstance();
        
        $this->trackingCodeService  = $container->get(TrackingCodeService::class);
        $this->parcelServiceService = $container->get(ParcelServiceService::class);
    }
    
    
    public function prepare_data()
    {
        $filter  = TrackingCodeFilters::create(TrackingCodeFilter::create('orderId', $this->orderId, 'eq'));
        $sorting = TrackingCodeSortings::create(TrackingCodeSorting::create('createdOn'));
        
        $parcelTrackingCodesArray = $this->trackingCodeService->getAllTrackingCodes(TrackingCodeSqlCriteria::create($filter,
                                                                                                                    $sorting),
                                                                                    TrackingCodeSqlPagination::createWithoutLimit(0));
        
        $this->set_content_data('parcel_tracking_codes_array', $parcelTrackingCodesArray);
        $this->set_content_data('orders_id', $this->orderId);
        $this->set_content_data('page_token', $this->pageToken);
        
        /* Options */
        $this->_buildOptionsHTML();
    }
    
    
    protected function _buildOptionsHTML()
    {
        $filter  = ParcelServiceFilters::create();
        $sorting = ParcelServiceSortings::create(ParcelServiceSorting::create('id'));
        
        $parcelServices = $this->parcelServiceService->getAllParcelServices(ParcelServiceSqlCriteria::create($filter,
                                                                                                             $sorting),
                                                                            ParcelServiceSqlPagination::createWithoutLimit(0));
        
        /** @var \Gambio\Admin\ParcelService\Model\ParcelService $parcelService */
        foreach ($parcelServices as $parcelService) {
            $key                      = $parcelService->id();
            $val                      = $parcelService->name();
            $parcelOptionsArray[$key] = $val;
            
            if ($parcelService->isDefault()) {
                $selected = $key;
            }
        }
        
        $this->set_content_data('parcel_tracking_service_options', $parcelOptionsArray);
        $this->set_content_data('parcel_tracking_service_options_selected', $selected);
    }
    
    
    /**
     * @param mixed $p_orderId
     */
    public function setOrderId($p_orderId)
    {
        $this->orderId = (int)$p_orderId;
    }
    
    
    /**
     * @param string $p_pageToken
     */
    public function setPageToken($p_pageToken)
    {
        $this->pageToken = (string)$p_pageToken;
    }
}